#ifndef __Projectile_h__
#define __Projectile_h__

#include <math.h>
#include "ogl.h"

#ifndef DToR
#define DToR(x) ((x)*3.1415926535897932384626433832795/180.0)
#endif
#ifndef RToD
#define RToD(x) ((x)*180.0/3.1415926535897932384626433832795)
#endif

#define PROJ_R 0.3f

class Projectile {

public:
   Projectile();
   ~Projectile();

   void setPlayer(int pnum) { this->pnum = pnum; };
   void setPos(float x,float y) { posx = x; posy = y; };
   void setVelocity(float x,float y) { velx = x; vely = y; };
   void setGravity(float x,float y) { gravx = x; gravy = y; };
   void setR(float r) { this->r = r; };
   int   getPlayer() { return pnum; };
   float getPosX() { return posx; };
   float getPosY() { return posy; };
   float getR() { return r; };
   void  setTrailEffectId(int eid) { trailId = eid; };
   int   getTrailEffectId() { return trailId; };
   void  launch() { ltime = 0; };
   void  zeroForce() { setGravity(0,0); };

   void update(float dt);
   virtual void render();

protected:

   void normalize(float &x,float &y);

   float posx,posy;
   float velx,vely;    // velocity vector
   float r;            // bb radius
   float gravx,gravy;  // gravity force vector
   float ltime;        // time we throw the projectile
   int   trailId;
   int   pnum;         // player number: 0,1

   static bool first_init;

};


#endif